import pygame
import random

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 20 - masking"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.lighting = False
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    #instance variables to be replaced with objects
    self.xrot = 0
    self.yrot = 0
    self.xspeed = 0
    self.yspeed = 0
    self.z = -40
    
    self.masking = True
    self.scene = 0
    self.roll = 0
    
  def initGL(self):
    print glGetString(GL_VENDOR)+" "+glGetString(GL_RENDERER)
    print glGetString(GL_VERSION)
    print glGetString(GL_EXTENSIONS)#.replace(" ","\n")
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    if not self.texloaded: self.loadGLTextures()
    #self.glinited = True
  def loadGLTextures(self):
    self.tnames = glGenTextures(5)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    tn = 0
    for t in "logo","mask1","image1","mask2","image2":
      self.textures.append(pygame.image.load("Data/"+t+".bmp"))
      idat = pygame.image.tostring(self.textures[-1],"RGB",True)
      #~ #near filter
      glBindTexture(GL_TEXTURE_2D,self.tnames[tn])
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
      glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[-1].get_width(),self.textures[-1].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
      tn += 1
    #self.textures[0] = None
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,200.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,-2)
    #draw logo
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glBegin(GL_QUADS)
    glTexCoord2d(0,0-self.roll); glVertex3f(-1.1,-1.1,0)
    glTexCoord2d(1,0-self.roll); glVertex3f(1.1,-1.1,0)
    glTexCoord2d(1,3-self.roll); glVertex3f(1.1,1.1,0)
    glTexCoord2d(0,3-self.roll); glVertex3f(-1.1,1.1,0)
    glEnd()
    #enable blending
    glEnable(GL_BLEND)
    glDisable(GL_DEPTH_TEST)
    if self.masking:
      glBlendFunc(GL_DST_COLOR,GL_ZERO)
    if self.scene: #Draw second scene
      glTranslatef(0,0,-1)
      glRotatef(360*self.roll,0,0,1)
      if self.masking:
        glBindTexture(GL_TEXTURE_2D,self.tnames[3])
        glBegin(GL_QUADS)
        glTexCoord2d(0,0); glVertex3f(-1.1,-1.1,0)
        glTexCoord2d(1,0); glVertex3f(1.1,-1.1,0)
        glTexCoord2d(1,1); glVertex3f(1.1,1.1,0)
        glTexCoord2d(0,1); glVertex3f(-1.1,1.1,0)
        glEnd()
      glBlendFunc(GL_ONE,GL_ONE)
      glBindTexture(GL_TEXTURE_2D,self.tnames[4])
      glBegin(GL_QUADS)
      glTexCoord2d(0,0); glVertex3f(-1.1,-1.1,0)
      glTexCoord2d(1,0); glVertex3f(1.1,-1.1,0)
      glTexCoord2d(1,1); glVertex3f(1.1,1.1,0)
      glTexCoord2d(0,1); glVertex3f(-1.1,1.1,0)
      glEnd()
    else:
      if self.masking:
        glBindTexture(GL_TEXTURE_2D,self.tnames[1])
        glBegin(GL_QUADS)
        glTexCoord2d(self.roll+0,0); glVertex3f(-1.1,-1.1,0)
        glTexCoord2d(self.roll+4,0); glVertex3f(1.1,-1.1,0)
        glTexCoord2d(self.roll+4,4); glVertex3f(1.1,1.1,0)
        glTexCoord2d(self.roll+0,4); glVertex3f(-1.1,1.1,0)
        glEnd()
      glBlendFunc(GL_ONE,GL_ONE)
      glBindTexture(GL_TEXTURE_2D,self.tnames[2])
      glBegin(GL_QUADS)
      glTexCoord2d(self.roll+0,0); glVertex3f(-1.1,-1.1,0)
      glTexCoord2d(self.roll+4,0); glVertex3f(1.1,-1.1,0)
      glTexCoord2d(self.roll+4,4); glVertex3f(1.1,1.1,0)
      glTexCoord2d(self.roll+0,4); glVertex3f(-1.1,1.1,0)
      glEnd()
    glEnable(GL_DEPTH_TEST)
    glDisable(GL_BLEND)
    self.roll+=.002
    if self.roll>1:
      self.roll -= 1.0

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        if not screen.fullscreen:
          screen.wi,screen.hi,screen.fullscreen=1024,768,True
        else:
          screen.wi,screen.hi,screen.fullscreen=640,480,False
        screen.resize()
      if e.key==pygame.K_l:
        screen.lighting = not screen.lighting
        if screen.lighting:
          glEnable(GL_LIGHTING)
        else:
          glDisable(GL_LIGHTING)
      if e.key==pygame.K_SPACE:
        screen.scene = not screen.scene
      if e.key==pygame.K_m:
        screen.masking = not screen.masking
  keys = pygame.key.get_pressed()
